<?php
/*
Plugin Name: WP Embed Facebook Premium
Plugin URI: http://www.wpembedfb.com
Description: Extends the free plugin with extra features ask any question on support <a href="http://www.wpembedfb.com/support">Support</a>
Author: Miguel Sirvent
Version: 1.4.7
Copyright: Miguel Sirvent - miguel@sigami.net
License: http://www.wpembedfb.com/wp-embed-facebook-premium-license/
*/

define("WPEMFBPLVER",'1.4.7');
define("WPEMFBPLDIR",plugin_dir_path( __FILE__ ));//TODO safe delete this constants
define("WPEMFBPLURL",plugin_dir_url( __FILE__ ));
define("WPEMFBPLSLUG",dirname(plugin_basename(__FILE__)));

require_once('lib/wpemfb-premium-plugin.php');

if(is_admin()){
    require_once('lib/wpemfb-premium-updater.php');
    require_once('lib/wpemfb-premium-admin.php');
    add_filter('wpemfb_admin',array('Wpemfb_Premium_Admin','wpemfb_admin'));//sidebar content
    add_action('wpemfb_admin_save_data',array('Wpemfb_Premium_Admin','wpemfb_admin_save_data'));//save number of posts
    add_action('wpemfb_options',array('Wpemfb_Premium_Admin','wpemfb_options'));//add section and save licence
    add_action('admin_notices',array('Wpemfb_Premium_Admin', 'admin_notices'));//propmts license
    add_filter('wpemfb_tabs',array('Wpemfb_Premium_Admin','wpemfb_tabs'));
}


require_once('lib/wpemfb-premium.php');
//require_once('lib/wpemfb-widget.php'); //TODO Finish this

add_action('init',array('Wpemfb_Premium_Plugin','init'));
register_activation_hook(__FILE__, array('Wpemfb_Premium_Plugin', 'install') );
register_uninstall_hook(__FILE__, array('Wpemfb_Premium_Plugin', 'uninstall') );

$lic = get_option('wpemfb_license','');
if(!empty($lic)){
    add_action('wp_enqueue_scripts', array('Wpemfb_Premium', 'wp_enqueue_scripts') );
    add_shortcode('fbfullpage', array('Wpemfb_Premium','full_page_shortcode'));
    add_shortcode('fbfullevent', array('Wpemfb_Premium','full_event_shortcode'));
    add_filter('wpemfb_fb_data', array('Wpemfb_Premium', 'album_extra_photos'),10,2);
    add_filter('wpemfb_template', array('Wpemfb_Premium', 'premium_event_template'),11,3);
    add_filter('wpemfb_api_string', array('Wpemfb_Premium', 'event_extra_data'),11,3);
}
