<?php
/*
 * You can create your own template by placing a copy of this file on yourtheme/plugins/wp-embed-fb/
 * to access all fb data print_r($fb_data)
 */
?>
<?php
ob_start();
echo isset($fb_data['location']['street']) ? '<p>'.$fb_data['location']['street'] : '';
echo isset($fb_data['location']['city']) ? ', '.$fb_data['location']['city'].'.</p>' : '';
?>

<ul class="ul">
<?php
//echo '<pre>'.wpautop(print_r($fb_data,true)).'</pre>';

echo isset($fb_data['phone']) && (strip_tags($fb_data['phone']) !== '')  ? '<li><span class="bold">Phone: </span>'.$fb_data['phone'].'</li>' : '';
echo isset($fb_data['attire']) ? '<li><span class="bold">Attire: </span>'.$fb_data['attire'].'</li>' : '';
echo isset($fb_data['price_range']) ? '<li><span class="bold">Price Range: </span>'.$fb_data['price_range'].'</li>' : '';

if(isset($fb_data['parking'])){
    $parking =  implode(", ", array_keys($fb_data['parking'],1));
    if(!empty($parking)){
        echo "<li><span class='bold'>Parking: </span>";
        echo trim($parking,', ');
        echo "</li>";
    }
}


if(isset($fb_data['payment_options'])){
    echo "<li><span class='bold'>Payment Options: </span>";
    echo implode(",", array_keys($fb_data['payment_options'],1));
    echo "</li>";
}


if(isset($fb_data['restaurant_specialties'])){
    echo "<li><span class='bold'>Restaurant Specialties: </span>";
    echo implode(",", array_keys($fb_data['restaurant_specialties'],1));
    echo "</li>";
}


if(isset($fb_data['restaurant_services"'])){
    echo "<li><span class='bold'>Restaurant Services: </span>";
    echo implode(",", array_keys($fb_data['restaurant_services'],1));
    echo "</li>";
}
?>
</ul>
<?php
$sidebar = ob_get_clean();
$has_sidebar = trim(strip_tags($sidebar));
?>
<div class="wef-<?php echo WP_Embed_FB::get_theme() ?> wef-measure" >
	<div class="cover" style="background-image: url('<?php echo $fb_data['cover']['source'] ?>'); background-position: 0% <?php echo $fb_data['cover']['offset_y'] ?>%;" onclick="window.open('<?php echo $fb_data['link'] ?>', '_blank')" ></div>
    <div class="row pad-top">
        <div class="col-2 text-center">
            <a href="<?php echo $fb_data['link'] ?>" target="_blank" rel="nofollow">
                <img src="<?php echo $fb_data['picture']['data']['url'] ?>" width="50px" height="50px" />
            </a>
        </div>
        <div class="col-10">
            <a href="<?php echo $fb_data['link'] ?>" target="_blank" rel="nofollow">
                <span class="title"><?php echo $fb_data['name'] ?></span>
            </a>
            <br>
            <?php
            if($fb_data['category'] == 'Musician/band'){
                echo isset($fb_data['genre']) ? $fb_data['genre'] : '';
            } else {
                _e($fb_data['category'],'wp-embed-facebook');
            }
            ?><br>
            <?php if(isset($fb_data["website"])) : ?>
                <a  href="<?php echo WP_Embed_FB::getwebsite($fb_data["website"]) ?>" title="<?php _e('Web Site', 'wp-embed-facebook')  ?>" target="_blank">
                    <?php _e('Web Site','wp-embed-facebook') ?>
                </a>
            <?php endif; ?>
            <div style="float: right;">
                <?php
                $opt = get_option('wpemfb_show_like');
                if($opt === 'true') :
                    echo WEF_Social_Plugins::like_btn('https://www.facebook.com/'.$fb_data['id'],array('share'=>'true','layout'=>'button_count'));
                else :
                    printf( __( '%d people like this.', 'wp-embed-facebook' ), $fb_data['likes'] );
                endif;
                ?>
            </div>
        </div>
    </div>
	<hr>
	<div class="row">
        <?php if($has_sidebar) : ?>
            <div class="col-4" style="vertical-align: top;">
                <script src="https://maps.googleapis.com/maps/api/js?v=3.exp"></script>
                <div id="map" style="height:150px"></div>
                <?php echo $sidebar ?>
            </div>
        <?php endif; ?>
		<div class="<?php echo $has_sidebar?'col-8':'col-12' ?>" style="vertical-align: top; <?php echo $has_sidebar?'':'padding:0 15%' ?>">
            <p style="text-align: center;">
                <a href="#" id="full_page_posts_toggle"><?php _e('View Posts','wp-embed-facebook') ?></a>
                &nbsp;|&nbsp;
                <a href="#"  id="full_page_events_toggle"><?php _e('Upcoming Events','wp-embed-facebook') ?></a>
            </p>
            <?php global $wp_embed; ?>
            <div id="full_page_posts">
			<?php foreach($fb_data['posts']['data'] as $fb_post) : ?>
				<?php if(isset($fb_post['picture']) || isset($fb_post['message'])) : ?>
                    <?php $width = 410 ?>
					<?php include(WP_Embed_FB_Plugin::get_path().'templates/'.WP_Embed_FB::get_theme().'/single-post.php') ?>
				<?php endif; ?>
			<?php endforeach; ?>
                <div class="row">
                    <div class="col-12 text-center">
                        <a class="clean-link" href="<?php echo "https://www.facebook.com/".$link[0] ?>" target="_blank" rel="nofollow">
                            View More
                        </a>
                    </div>
                </div>
            </div>
            <div id="full_page_events" style="display:none;">
                <?php
                $event_count = 0;
                $events = $fb_data['events']['data'];
                if(!empty($events)){
	                $old_time_zone = date_default_timezone_get();
	                foreach( array_reverse($events) as $event){
		                if( strtotime($event['start_time']) >= time() ){
			                $event_count++;
			                $start_time_format = 'l, j F Y g:i a';
			                $timezone = isset( $event['timezone'] ) ? $event['timezone'] : get_option( 'timezone_string' );
			                date_default_timezone_set( $timezone );
			                $start_time = date_i18n( $start_time_format, strtotime( $event['start_time'] ) );
			                ?>
			                <div class="wef-default wef-measure" style="max-width: 410px" >
				                <div class="cover" style="background-image: url('<?php echo $event['cover']['source'] ?>'); background-position: 0% <?php echo $event['cover']['offset_y'] ?>%;" onclick="window.open('https://www.facebook.com/<?php echo $event['id'] ?>', '_blank')" ></div>
				                <div class="row pad-top">
					                <div class="col-12">
						                <a href="https://www.facebook.com/<?php echo $event['id'] ?>" target="_blank" rel="nofollow">
							                <span class="title"><?php echo $event['name'] ?></span>
						                </a>
						                <p><?php echo $start_time ?></p>
						                <p>
							                <?php
							                if ( isset( $event['place']['id'] )  ) {
								                if(( $event['place']['id'] !== $fb_data['id'] )){
									                _e( '@ ', 'wp-embed-facebook' );
									                echo '<a href="https://www.facebook.com/' . $fb_data['place']['id'] . '" target="_blank">' . $fb_data['place']['name'] . '</a>';
								                }
							                } else {
								                echo isset( $fb_data['place']['name'] ) ? __( '@ ', 'wp-embed-facebook' ) . $fb_data['place']['name'] : '';
							                }
							                ?>
						                </p>
					                </div>
				                </div>
			                </div>
			                <?php
		                }
	                }
	                date_default_timezone_set( $old_time_zone );
                }
                ?>
                <?php if($event_count == 0) : ?>
                    <p><?php _e('No Upcoming Events','wp-embed-facebook-premium') ?></p>
                <?php endif; ?>
            </div>
		</div>
	</div>
</div>
<script>
    <?php if($has_sidebar) : ?>
    var map;
    function initialize() {
        var latlong = new google.maps.LatLng(<?php echo $fb_data['location']['latitude'] ?>, <?php echo $fb_data['location']['longitude'] ?>);
        var mapOptions = {
            zoom: 6,
            center: latlong,
        };
        map = new google.maps.Map(document.getElementById('map'), mapOptions);
        var marker = new google.maps.Marker({
            position: latlong,
            map: map,
        });

    }
    google.maps.event.addDomListener(window, 'load', initialize);
    <?php endif; ?>
    jQuery(document).ready(function($) {
        $("#full_page_posts_toggle").click( function (event) {
            event.preventDefault();
            $("#full_page_posts").show();
            $("#full_page_events").hide();
	        resize_cover();
        });
        $("#full_page_events_toggle").click( function (event) {
            event.preventDefault();
            $("#full_page_posts").hide();
            $("#full_page_events").show();
	        resize_cover();
        });
    });
</script>