<?php
class Wpemfb_Premium_Plugin {
	/**
	 * @var string Plugin directory
	 */
	private static $path = null;
	/**
	 * @var string Plugin url
	 */
	private static $url = null;
	/**
	 * @var string Plugin slug
	 */
	private static $slug = null;
	static function get_path(){
		if(self::$path){
			return self::$path;
		} else {
			self::$path = dirname(plugin_dir_path( __FILE__ )).'/';
			return self::$path;
		}
	}
	static function get_url(){
		if(self::$url){
			return self::$url;
		} else {
			self::$url = dirname(plugin_dir_url( __FILE__ )).'/';
			return self::$url;
		}
	}
	static function get_slug(){
		if(self::$slug){
			return self::$slug;
		} else {
			self::$slug = dirname(dirname(plugin_basename(__FILE__)));
			return self::$slug;
		}
	}
	/**
	 * Save default values to data base
	 */
	static function install(){
		$defaults = self::getdefaults();
		foreach ($defaults as $option => $value) {
			$opt = get_option($option);
			if($opt === false)
				update_option($option, $value);
		}
		return;
	}
	/**
	 * Delete all plugin options on uninstall
	 */
	static function uninstall(){
		$defaults = self::getdefaults();
		if ( is_multisite() ) {
			$sites = wp_get_sites();
			foreach ($sites as $site) {
				switch_to_blog($site['blog_id']);
				foreach ($defaults as $option => $value ) {
					delete_option($option);
				}
			}
			restore_current_blog();
		} else {
			foreach ($defaults as $option => $value ) {
				delete_option($option);
			}
		}
		return;
	}
	/**
	 * Default options
	 */
	static function getdefaults()
	{
		return array(
			'wpemfb_license' => '',
			'wpemfb_max_posts_premium' => '5'
		);
	}
	//Load translations
	static function init(){
		load_plugin_textdomain( 'wp-embed-facebook-premium', false, self::get_slug().'/lang' );
	}
	static function wp_enqueue_scripts(){
	}

}