<?php
class Wpemfb_Premium_Admin {
    static function admin_notices(){
        global $pagenow;
        if(!is_plugin_active('wp-embed-facebook/wp-embed-facebook.php')){
            ?>
            <div class="error">
                <h4><?php _e('WP Embed Facebook Free Plugin is required.','wp-embed-facebook-premium'); ?></h4>
                <ol>
                <?php
                $plugin_file = 'wp-embed-facebook/wp-embed-facebook.php';
                if( !file_exists(dirname(Wpemfb_Premium_Plugin::get_path()).'/'.$plugin_file) && is_super_admin() ){
                    $install = '<a href="' . wp_nonce_url(network_admin_url() . 'update.php?action=install-plugin&amp;plugin=wp-embed-facebook', 'install-plugin_' . 'wp-embed-facebook-premium') . '"title="' . esc_attr__('Install WP Embed Facebook', 'wp-embed-facebook-premium') . '" class="edit">' . __('Install WP Embed Facebook', 'wp-embed-facebook-premium') . '</a>';
                    echo '<li>' . $install . '</li>';
                } else {
                    global $s;
                    $context = 'all';
                    $activate = '<a href="' . wp_nonce_url(admin_url() . 'plugins.php?action=activate&amp;plugin=' . $plugin_file . '&amp;plugin_status=' . $context . '&amp;s=' . $s, 'activate-plugin_' . $plugin_file) . '" title="' . esc_attr__('Activate WP Embed Facebook for this site', 'wp-embed-facebook-premium') . '" class="edit">' . __('Activate WP Embed Facebook for this site', 'wp-embed-facebook-premium') . '</a>';
                    echo '<li>' . $activate . '</li>';
                }
                ?>
                </ol>
            </div>
        <?php
        }
        if($pagenow == 'plugins.php' ){
                $license_id = get_option('wpemfb_license','');
                $notice = '';
                if(empty($license_id)){
                    $notice = 'missing';
                }
                if(isset($_POST['wpemfb-license']) && wp_verify_nonce( $_POST['_wpnonce'], 'wpemfb_license_nonce') ){
                    $clean = trim($_POST['wpemfb-license']);
                    if(!empty($clean)){
                        $valid = self::validate_license($clean);
                        if($valid[0]){
                            update_option('wpemfb_license',$clean);
                            $notice = 'ok';
                        } else {
                            $error_msg = $valid[1];
                            $notice = 'error';
                            update_option('wpemfb_license','');
                        }
                    } else {
                        update_option('wpemfb_license','');
                    }
                }
                switch($notice){
                    case 'missing':
                        ?>
                        <div class="error">
                            <h4><?php _e('WP Embed Facebook License Missing','wp-embed-facebook-premium'); ?></h4>
                            <p><?php _e('Enter license to receive updates','wp-embed-facebook-premium'); ?></p>
                            <?php self::license_form() ?>
                        </div>
                        <?php
                        break;
                    case 'ok':
                        ?>
                        <div class="updated notice is-dismissible">
                            <h4><?php _e('WP Embed Facebook License is ok','wp-embed-facebook-premium'); ?></h4>
                            <p><?php _e('Thank you! You are Awesome!','wp-embed-facebook-premium'); ?></p>
                        </div>
                        <?php
                        break;
                    case 'error':
                        ?>
                        <div class="error">
                            <h4><?php _e('WP Embed Facebook License ERROR','wp-embed-facebook-premium'); ?></h4>
                            <p>
                                <?php echo $error_msg; ?>
                                <br>
                                <?php _e('Try again please.','wp-embed-facebook-premium'); ?>
                            </p>
                            <?php self::license_form() ?>
                        </div>
                        <?php
                        break;
                    default:
                        return;
                        break;
                }

        }
    }
    static function license_form(){
        ob_start();?>
        <form action="<?php echo admin_url('plugins.php') ?>" method="post" >
            <?php wp_nonce_field('wpemfb_license_nonce'); ?>
            <label for="wpemfb-license"><?php _e('License Key:','wp-embed-facebook-premium'); ?></label>
            <input type="text" name="wpemfb-license">
            <input type="submit" class="button button-primary" value="<?php _e('Save','wp-embed-facebook-premium') ?>">
        </form>
        <?php ob_end_flush();
    }
    static function wpemfb_admin_save_data(){
        if(isset($_POST['wpemfb_max_posts_premium'])){
            update_option('wpemfb_max_posts_premium', sanitize_text_field($_POST['wpemfb_max_posts_premium']));
        }
    }
    static function wpemfb_admin($data){
        $license = get_option('wpemfb_license','');
        if(empty($license)){
            return $data;
        } else {
            //TODO: probably test license validity here and show expiration date.
            ob_start();
            ?>
            <h1><?php _e('You have a License','wp-embed-facebook-premium'); ?></h1>
            <p><?php _e('Share what you want to see on this plugin','wp-embed-facebook-premium'); ?></p>
            <p><strong><a href="http://www.wpembedfb.com/support/ask"><?php _e('Support Forum','wp-embed-facebook-premium'); ?></a></strong></p>
            <p style="text-align: center;"><?php _e('You are awesome! Remember that.','wp-embed-facebook-premium'); ?></p>
        <?php
        }
    }
    static function wpemfb_options(){
        if(isset($_POST['wpemfb-license']) && !is_multisite()){
            $clean = trim($_POST['wpemfb-license']);
            if(!empty($clean)){
                $valid = self::validate_license($clean);
                if($valid[0]){
                    update_option('wpemfb_license',$clean);
                } else {
                    $error_msg = $valid[1];
                    update_option('wpemfb_license','');
                }
            } else {
                update_option('wpemfb_license','');
            }
        }
        ob_start();
//        WP_Embed_FB_Admin::section()
        ?>
        <section class="sections">
        <h4><?php _e('Premium Options', 'wp-embed-facebook-premium') ?></h4>
        <div>
            <table>
                <tbody>
                    <tr valign="middle">
                        <th><?php _e('License','wp-embed-facebook-premium'); ?></th>
                        <td>
                            <?php echo isset($error_msg)?'<p>'.$error_msg.'</p>':'' ?>
                            <input type="text" name="wpemfb-license" value="<?php echo get_option('wpemfb_license') ?>" size="38"  />
                        </td>
                    </tr>
                    <tr valign="middle">
                        <th><?php _e('Number of posts on full page','wp-embed-facebook-premium') ?></th>
                        <td>
                            <input type="number" name="wpemfb_max_posts_premium" value="<?php echo get_option('wpemfb_max_posts_premium') ?>"  style="width: 60px;"/>
                        </td>
                    </tr>
            </table>
	        <h4>Available shortcodes</h4>
	        <p><strong>Full Page</strong> [fbfullpage url ]</p>
	        <p><strong>Full Event</strong> [fbfullevent url ]</p>
        </div>
        </section>
        <?php
        ob_end_flush();
    }
    static function validate_license($license_query){
        global $WpemfbUpdater;
        $home = get_home_url();
        $raw_license = $WpemfbUpdater->remote_post('validate_license',array('license'=>$license_query,'site_url'=>$home));
        $error_msg = '';
        if( !is_wp_error($raw_license) && $raw_license['response']['code'] == 200 ){
            if(empty($raw_license['body'])){
                $error_msg = "Unable to reach license server try again";
            } else {
                $license = unserialize($raw_license['body']);
                if(is_wp_error($license)){
                    $array = $license->errors;
                    $first = array_shift($array);
                    $error_msg = $first[0];
                }
            }
        } else {
            $error_msg = "Unable to reach license server try again please";
        }
        if(empty($error_msg)){
            return array(true,$license);
        } else {
            return array(false,$error_msg);
        }
    }
    static function wpemfb_tabs($tabs){
	    array_splice($tabs,2,0,array(__( 'Premium', 'wp-embed-facebook-premium' )));
	    return $tabs;
    }
}