<?php
$height            = $width * $prop;
$start_time_format = 'l, j F Y g:i a';
$old_time_zone = date_default_timezone_get();
if(get_option('wpemfb_ev_local_tz') == 'true'){
	$timezone = get_option( 'timezone_string' );
} else {
	$timezone = isset( $fb_data['timezone'] ) ? $fb_data['timezone'] : get_option( 'timezone_string' );
}
date_default_timezone_set( $timezone );
$start_time = date_i18n( $start_time_format, strtotime( $fb_data['start_time'] ) );
date_default_timezone_set( $old_time_zone );
?>
<div class="wef-classic wef-measure" style="max-width: <?php echo $width ?>px">
	<?php if(isset($fb_data['cover'])) : ?>
		<div class="cover" style="height:<?php echo $height ?>px; background-image: url('<?php echo $fb_data['cover']['source'] ?>'); background-position: 0% <?php echo $fb_data['cover']['offset_y'] ?>%;" onclick="window.open('https://www.facebook.com/<?php echo $fb_data['id'] ?>', '_blank')" ></div>
	<?php endif; ?>
	<div class="row pad-top">
		<div class="col-12">
			<a href="https://www.facebook.com/<?php echo $fb_data['id'] ?>" target="_blank" rel="nofollow">
				<span class="title"><?php echo $fb_data['name'] ?></span>
			</a>
			<p><?php echo $start_time ?></p>
			<p>
				<?php
				if ( isset( $fb_data['place']['id'] ) ) {
					_e( '@ ', 'wp-embed-facebook' );
					echo '<a href="https://www.facebook.com/' . $fb_data['place']['id'] . '" target="_blank">' . $fb_data['place']['name'] . '</a>';
					if(isset($fb_data['place']['location']) && !empty($fb_data['place']['location']) ){
						$location = $fb_data['place']['location'];
						$street = (isset($location['street']) && !empty($location['street']) ) ? $location['street'] : '';
						$city = (isset($location['city']) && !empty($location['city']) ) ? $location['city'].',' : '';
						$country = (isset($location['country']) && !empty($location['country']) ) ? $location['country'].'.' : '';
						echo "<span class=\"event_address\"> $street $city $country</span>";
					}
				} else {
					echo isset( $fb_data['place']['name'] ) ? __( '@ ', 'wp-embed-facebook' ) . $fb_data['place']['name'] : '';
				}
				?>
			</p>
			<p><?php
				_e( 'Admins: ', 'wp-embed-facebook-premium' );
				$admins = '';
				foreach($fb_data['admins']['data'] as $admin){
					$admins .= "<a href=\"https://www.facebook.com/{$admin['id']}\">{$admin['name']}</a>,";
				}
				echo trim($admins.',');
				?>
			</p>
		</div>
	</div>
</div>