<?php

class Wpemfb_Premium
{

    static function full_page_shortcode($atts) //TODO remake this entirely
    {
        $license = get_option('wpemfb_license', '');
        if (!empty($license) && class_exists('WP_Embed_FB')){
	        if (!empty($atts) && isset($atts[0]) && (strpos($atts[0],'facebook.com') !== false  ) ) {
		        $clean = trim($atts[0],'=');
		        $clean = trim($clean);
		        $juice = str_replace(array('https','http','://facebook.com/','://m.facebook.com/','://facebook.com/','://www.facebook.com/'),'',$clean);
		        if( ($qm = strpos($juice,'?')) !== false ){
			        $juice = substr($juice,0,$qm);
		        }
		        $num_posts = get_option("wpemfb_max_posts_premium",0);
		        $api_string = $juice.'?fields=name,picture,is_community_page,link,id,cover,category,website,likes,genre,events{id,name,start_time,end_time,owner,place,timezone,cover},location,phone,attire,price_range,parking,payment_options,restaurant_specialties,restaurant_services';
		        if(intval($num_posts) > 0)
			        $api_string .= ',posts.limit('.$num_posts.'){id,full_picture,type,via,source,parent_id,call_to_action,story,place,child_attachments,icon,created_time,message,description,caption,name,shares,link,picture,object_id,likes.limit(1).summary(true),comments.limit(1).summary(true)}';
		        $fbsdk = WP_Embed_FB::get_fbsdk();
		        try{
			        $fb_data = $fbsdk->api('/v2.5/'.$api_string);
		        } catch(FacebookApiException $e){
			        $fb_data = '<p><a href="https://www.facebook.com/'.$juice.'" target="_blank" rel="nofollow">https://www.facebook.com/'.$juice.'</a>';
			        if(is_super_admin()){
				        $error = $e->getResult();
				        $fb_data .= '<br><span style="color: #4a0e13">'.__('Error').':&nbsp;'.$error['error']['message'].'</span>';
			        }
			        $fb_data .= '</p>';
		        }
		        if(is_array($fb_data)){
			        ob_start();
			        include(self::wpemfb_template_fullpage());
			        return ob_get_clean();
		        } else {
			        return $fb_data;
		        }
	        } else {
		        return __('invalid facebook link','wp-embed-facebook-premium');
	        }
        } else {
	        return __('no license present','wp-embed-facebook-premium');
        }
    }

    static function full_event_shortcode($atts) {
        $license = get_option('wpemfb_license', '');
        if (!empty($license) && class_exists('WP_Embed_FB')){
	        if (!empty($atts) && isset($atts[0]) && (strpos($atts[0],'facebook.com') !== false  ) ) {
		        wp_enqueue_style('wpemfb-pre');
		        $clean = trim($atts[0],'=');
		        $clean = trim($clean);
		        $juice = str_replace(array('https','http','://facebook.com/','://m.facebook.com/','://facebook.com/','://www.facebook.com/'),'',$clean);
//		        remove_filter('wpemfb_template', array('Wpemfb_Premium', 'premium_event_template'),11);
		        add_filter('wpemfb_template', array('Wpemfb_Premium', 'wpemfb_template_fullevent'),12);
		        $embed =  WP_Embed_FB::fb_embed(array('https','://www.facebook.com/',$juice));
		        remove_filter('wpemfb_template', array('Wpemfb_Premium', 'wpemfb_template_fullevent'));
		        return $embed;
	        } else {
		        return __('invalid facebook link','wp-embed-facebook-premium');
	        }
        } else{
		    return __('invalid facebook link','wp-embed-facebook-premium');
	    }

    }

    static function wpemfb_template_fullpage()
    {
        if(file_exists(get_stylesheet_directory().'/plugins/wp-embed-facebook/full-page.php'))
            return get_stylesheet_directory().'/plugins/wp-embed-facebook/full-page.php';
        else
            return Wpemfb_Premium_Plugin::get_path() . "templates/shortcodes/full-page.php";
    }

    static function wpemfb_template_fullevent($template)
    {
        if(file_exists(get_stylesheet_directory().'/plugins/wp-embed-facebook/full-event.php'))
            return get_stylesheet_directory().'/plugins/wp-embed-facebook/full-event.php';
        else
            return WPEMFBPLDIR . "templates/shortcodes/full-event.php";
    }

    static function wp_enqueue_scripts()
    {
        wp_register_style('wpemfb-pre', Wpemfb_Premium_Plugin::get_url() . "lib/css/wpemfb-prem.css");
    }

	static function album_extra_photos($fb_data,$type){
		if($type == 'album' && WP_Embed_FB::$num_photos > 100 && $fb_data['count'] > 100){
			$pages = min( ceil($fb_data['count'] / 100), ceil(WP_Embed_FB::$num_photos / 100) ) ;
			for($i=2; $i<=$pages; $i++){
				$after = $fb_data['photos']['paging']['cursors']['after'];
				$fbsdk = WP_Embed_FB::get_fbsdk();
				$new_photos = $fbsdk->api("{$fb_data['id']}?fields=photos.limit(100).fields(name,picture,source,id).after($after)");
				$fb_data['photos']['data'] = array_merge($fb_data['photos']['data'], $new_photos['photos']['data']);
				$fb_data['photos']['paging']['cursors']['after'] = $new_photos['photos']['paging']['cursors']['after'];
			}
		}
		return $fb_data;
	}

	static function premium_event_template($template,$fb_data,$type){
		if($type == 'event' && (strpos($template,get_stylesheet_directory()) === false)){
			return Wpemfb_Premium_Plugin::get_path().'templates/'.WP_Embed_FB::get_theme().'/event.php';
		}
		return $template;
	}

	static function event_extra_data($api_string,$fb_id,$type){
		if($type == 'event')
			return $api_string.',admins,description';
		return $api_string;
	}

}
